import java.awt.*;
import javax.swing.*;

/** An instance of IntLabel is an integer that is associated
    with a JLabel that appears on the GUI. The purpose of having
    a class for this is to ensure that whenever the integer is
    changed, the correspondingJ Label is also changed. */

public class IntLabel {
	// in is the integer, and JLabel lab ALWAYS contains this
	// integer as a String, followed by two blanks
		private int in;
		private JLabel lab;
	
	/** Constructor: an integer with initial value i
	    that is associated with l */
	public IntLabel(int i, JLabel l) {
		in= i;
		lab= l;
		lab.setText(String.valueOf(i) + "  ");
	}

	/** Return the value of the integer */
	public int getInt()
		{return in;}
		
	/** Set the value of the integer to i */
	public void setInt(int i) {
		in= i;
		lab.setText(String.valueOf(i) + "  ");
	}
	
	/** A representation (the integer) of this IntLabl */
	public String toString() {
		return String.valueOf(in);
	}
}